<?php

namespace CodeAlfa\Module\JchDashIcons\Administrator\Dispatcher;

use JchOptimize\Core\Admin\Icons;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;

use function defined;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die('Restricted Access');
// phpcs:enable PSR1.Files.SideEffects

class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    public function getLayoutData()
    {
        $data = parent::getLayoutData();

        $component = $this->getApplication()->bootComponent('com_jchoptimize');
        $icons = $component->getContainer()->get(Icons::class);
        $mvcFactory = $component->getMVCFactory();

        $data['buttons'] = $this->getHelperFactory()->getHelper('JchDashIconsHelper')
            ->getButtons($data['params'], $icons, $mvcFactory);

        return $data;
    }
}
