<?php

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerScript;
use Joomla\CMS\Language\Text;
use Joomla\Component\Modules\Administrator\Model\ModuleModel;
use Joomla\Database\DatabaseDriver;
use Joomla\Database\ParameterType;

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 *  @package   jchoptimize/core
 *  @author    Samuel Marshall <samuel@jch-optimize.net>
 *  @copyright Copyright (c) 2024 Samuel Marshall / JCH Optimize
 *  @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */
class Mod_JchdashiconsInstallerScript extends InstallerScript
{
    protected $allowDowngrades = true;

    protected ?ModuleModel $moduleModel = null;

    public function postflight(string $type)
    {
        if ($type == 'install' || $type == 'update') {
            $instances = $this->getInstances(true);

            if (!$this->deleteModules($instances)) {
                return false;
            }

            $module = [
                'asset_id' => 0,
                'language' => '*',
                'note' => '',
                'published' => 1,
                'module' => $this->extension,
                'showtitle' => 1,
                'access' => 1,
                'client_id' => 1,
                'position' => 'cpanel-com-jchoptimize-cpanel'
            ];

            foreach ($this->modules() as $dashIconModule) {
                $module['id'] = $dashIconModule['id'];
                $module['title'] = $dashIconModule['title'];
                $module['ordering'] = $dashIconModule['ordering'];
                $module['params'] = $dashIconModule['params'];

                if (!$this->getModuleModel()->save($module)) {
                    Factory::getApplication()->enqueueMessage(
                        Text::sprintf('MOD_JCHDASHICONS_INSTALL_ERROR', $this->getModuleModel()->getError())
                    );
                }
            }
        }
    }

    private function getModuleModel()
    {
        if ($this->moduleModel === null) {
            $this->moduleModel = Factory::getApplication()
                ->bootComponent('com_modules')
                ->getMVCFactory()
                ->createModel('Module', 'Administrator', ['ignore_request' => true]);
        }

        return $this->moduleModel;
    }

    private function modules(): array
    {
        return [
             [
                'id' => 0,
                'title' => 'Optimize Files',
                'ordering' => 1,
                'params' => [
                    'header_icon' => 'none fa fa-file-download',
                    'context' => 'automatic',
                    'module_tag' => 'div',
                    'bootstrap_size' => '12',
                    'header_tag' => 'h2',
                    'header_class' => '',
                    'style' => '0'
                ]
             ],
             [
                'id' => 0,
                'title' => 'Notifications',
                'ordering' => 3,
                'params' => [
                    'header_icon' => 'none fa fa-exclamation-circle',
                    'context' => 'notifications',
                    'module_tag' => 'div',
                    'bootstrap_size' => '0',
                    'header_tag' => 'h2',
                    'header_class' => '',
                    'style' => '0'
                ]
             ],
             [
                'id' => 0,
                'title' => 'Image/CDN Features',
                'ordering' => 4,
                'params' => [
                    'header_icon' => 'none fa fa-image',
                    'context' => 'images',
                    'module_tag' => 'div',
                    'bootstrap_size' => '12',
                    'header_tag' => 'h2',
                    'header_class' => '',
                    'style' => '0'
                ]
             ],
             [
                'id' => 0,
                'title' => 'Utility Tasks',
                'ordering' => 5,
                'params' => [
                    'header_icon' => 'none fa fa-tasks',
                    'context' => 'utility',
                    'module_tag' => 'div',
                    'bootstrap_size' => '0',
                    'header_tag' => 'h2',
                    'header_class' => '',
                    'style' => '0'
                ]
             ],
             [
                'id' => 0,
                'title' => 'CSS Features',
                'ordering' => 6,
                'params' => [
                    'header_icon' => 'none fa fa-css3',
                    'context' => 'css',
                    'module_tag' => 'div',
                    'bootstrap_size' => '0',
                    'header_tag' => 'h2',
                    'header_class' => '',
                    'style' => '0'
                ]
             ],
             [
                'id' => 0,
                'title' => 'Advanced Features',
                'ordering' => 7,
                'params' => [
                    'header_icon' => 'none fa fa-users-cog',
                    'context' => 'advanced',
                    'module_tag' => 'div',
                    'bootstrap_size' => '0',
                    'header_tag' => 'h2',
                    'header_class' => '',
                    'style' => '0'
                ]
             ]
        ];
    }

    private function deleteModules(array $instances): bool
    {
        try {
            foreach ($instances as $pk) {
                $pk = (int)$pk;
                $db = Factory::getContainer()->get(DatabaseDriver::class);
                $query = $db->getQuery(true)
                    ->delete($db->quoteName('#__modules'))
                    ->where($db->quoteName('id') . ' = :id')
                    ->bind(':id', $pk, ParameterType::INTEGER);
                $db->setQuery($query);
                $db->execute();

                $this->deleteMenuAssignments($pk);
            }

            return true;
        } catch (Exception) {
            return false;
        }
    }

    private function deleteMenuAssignments(int $pk): void
    {
        $db = Factory::getContainer()->get(DatabaseDriver::class);
        $query = $db->getQuery(true)
            ->delete($db->quoteName('#__modules_menu'))
            ->where($db->quoteName('moduleid') . ' = :moduleid')
            ->bind(':moduleid', $pk, ParameterType::INTEGER);
        $db->setQuery($query);
        $db->execute();
    }
}
