<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 *  @package   jchoptimize/core
 *  @author    Samuel Marshall <samuel@jch-optimize.net>
 *  @copyright Copyright (c) 2023 Samuel Marshall / JCH Optimize
 *  @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace CodeAlfa\Component\JchOptimize\Administrator\Extension;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\MVC\Controller\ControllerInterface;
use Joomla\CMS\MVC\Factory\MVCFactory;
use Joomla\CMS\MVC\Model\ModelInterface;
use Joomla\CMS\MVC\View\ViewInterface;
use Joomla\DI\ContainerAwareInterface;
use Joomla\DI\ContainerAwareTrait;
use Joomla\Input\Input;
use ReflectionClass;
use ReflectionMethod;
use ReflectionNamedType;

use function defined;
use function str_starts_with;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die('Restricted Access');
// phpcs:enable PSR1.Files.SideEffects

class MVCContainerFactory extends MVCFactory implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    public function createController(
        $name,
        $prefix,
        array $config,
        CMSApplicationInterface $app,
        Input $input
    ): ?ControllerInterface {
        $controller = parent::createController($name, $prefix, $config, $app, $input);

        $this->setDependenciesOnObject($controller);

        return $controller;
    }

    public function createModel($name, $prefix = '', array $config = []): ?ModelInterface
    {
        $model = parent::createModel($name, $prefix, $config);

        $this->setDependenciesOnObject($model);

        return $model;
    }

    public function createView($name, $prefix = '', $type = '', array $config = []): ?ViewInterface
    {
        $view = parent::createView($name, $prefix, $type, $config);

        $this->setDependenciesOnObject($view);

        return $view;
    }

    private function setDependenciesOnObject($object): void
    {
        if ($object instanceof ContainerAwareInterface) {
            $object->setContainer($this->getContainer());
        }

        if ($object !== null) {
            $reflection = new ReflectionClass($object);
            $methods = $reflection->getMethods(ReflectionMethod::IS_PUBLIC);
            foreach ($methods as $method) {
                if (
                    str_starts_with($method->getName(), 'set')
                    && $method->getDeclaringClass()->getName() === $reflection->getName()
                ) {
                    $parameters = $method->getParameters();
                    if (count($parameters) == 1 && $parameters[0]->hasType()) {
                        $dependency = $parameters[0]->getType();
                        if ($dependency instanceof ReflectionNamedType) {
                            $class = $dependency->getName();
                            if ($this->getContainer()->has($class)) {
                                $object->{$method->getName()}($this->getContainer()->get($class));
                            }
                        }
                    }
                }
            }
        }
    }
}
