<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/joomla-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

use JchOptimize\Core\Admin\AdminHelper;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

include_once dirname(__FILE__) . '/excludejspei.php';

class JFormFieldIncludehttp2 extends JFormFieldExcludejspei
{
    public $type = 'includehttp2';
    public string $filegroup = 'file';
    protected string $valueType = 'url';
    protected string $option1 = 'anonymous';
    protected string $option2 = 'use-credentials';

    protected function getInput(): string
    {
        if (!JCH_PRO) {
            return AdminHelper::proOnlyField();
        } else {
            return parent::getInput();
        }
    }

    protected function fieldHeader(): string
    {
        return <<<HTML
<div class="jch-js-fieldset-children jch-js-excludes-header">
<span class="jch-js-ieo-header">&nbsp;&nbsp;&nbsp;Crossorigin:&nbsp;&nbsp;'anonymous'&nbsp;&nbsp;</span>
<span class="jch-js-dontmove-header">&nbsp;&nbsp;'use-credentials'&nbsp;&nbsp;&nbsp;</span>
</div>
HTML;
    }
}
