<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/core
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2023 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

use CodeAlfa\Component\JchOptimize\Administrator\Extension\JchOptimizeComponent;
use CodeAlfa\Component\JchOptimize\Administrator\Service\Provider\Logger;
use CodeAlfa\Component\JchOptimize\Administrator\Service\Provider\MVCContainerFactory;
use CodeAlfa\Component\JchOptimize\Administrator\Service\Provider\Params;
use CodeAlfa\Component\JchOptimize\Administrator\Service\Provider\PlatformUtils;
use JchOptimize\Core\Debugger;
use JchOptimize\Core\Html\HtmlElementBuilder;
use JchOptimize\Core\Service\Provider\Admin;
use JchOptimize\Core\Service\Provider\LaminasCache;
use JchOptimize\Core\Service\Provider\Callbacks;
use JchOptimize\Core\Service\Provider\Core;
use JchOptimize\Core\Service\Provider\FeatureHelpers;
use JchOptimize\Core\Service\Provider\SharedEvents;
use JchOptimize\Core\Service\Provider\Spatie;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die('Restricted Access');
// phpcs:enable PSR1.Files.SideEffects

require_once __DIR__ . '/../autoload.php';

return new class implements ServiceProviderInterface {
    public function register(Container $container): void
    {
        $container->registerServiceProvider(new MVCContainerFactory('\\CodeAlfa\\Component\\JchOptimize'));
        $container->registerServiceProvider(new ComponentDispatcherFactory('\\CodeAlfa\\Component\\JchOptimize'));

        //Core Services
        $container->registerServiceProvider(new SharedEvents())
            ->registerServiceProvider(new Core())
            ->registerServiceProvider(new Callbacks())
            ->registerServiceProvider(new LaminasCache())
            ->registerServiceProvider(new Admin());

        if (JCH_PRO) {
            $container->registerServiceProvider(new FeatureHelpers())
                ->registerServiceProvider(new Spatie());
        }

        //Platform Services
        $container->registerServiceProvider(new PlatformUtils())
            ->registerServiceProvider(new Params())
            ->registerServiceProvider(new Logger());

        $container->set(
            ComponentInterface::class,
            function (Container $container) {
                $component = new JchOptimizeComponent(
                    $container->get(ComponentDispatcherFactoryInterface::class)
                );

                $component->setRegistry($container->get(Registry::class));
                $component->setMVCFactory($container->get(MVCFactoryInterface::class));
                $component->setContainer($container);

                return $component;
            }
        );

        Debugger::setContainer($container);
        HtmlElementBuilder::setContainer($container);
    }
};
